import es
import cfglib
import playerlib

info = es.AddonInfo()
info.name = "WA NoBlock"
info.basename = "wanoblock"
info.url = "http://tbbclan.co.cc"
info.version = "1.01"
info.author = "W-A-R-R-I-O-R"

es.ServerVar ("WA NoBlock", info['version'], "by W-A-R-R-I-O-R",).makepublic()

config = cfglib.AddonCFG(es.getAddonPath(info.basename) + '/' + info.basename + '.cfg')

wanb_enable = config.cvar('wanb_enable', 1, 'Enable/Disable WA NoBlock')

wanb_advert = config.cvar('wanb_advert', 1, 'Enable/Disable advertisements')
wanb_advert_message = config.cvar('wanb_advert_message', '#green[#lightgreenW#lightgreenA#lightgreenN#greeno#lightgreenB#greenlock]#default is enabled', 'WA NoBlock advertisement')

wanb_hostages = config.cvar('wanb_hostages', 1, 'Enable/Disable NoBlock for hostages')
wanb_minimum_players = config.cvar('wanb_minimum_players', 0, 'Mimimum amount of players before NoBlock is enabled, 0 for always enabled')

config.write()

wanb_active = 0
wanb_collision = '5' # Solid by default

def load():
    config.execute()
  
def round_end(event):
    global wanb_active
    global wanb_collision
    if wanb_minimum_players == 0 or len(playerlib.getPlayerList('#human')) >= wanb_minimum_players:
        wanb_collision = '2'
    else:
        wanb_collision = '5'

def round_start(event):
    if wanb_enable == 1:
        if wanb_advert == 1:
            es.msg('#multi', str(wanb_advert_message))
        if wanb_hostages == 1 and wanb_enable == 1:
            for hostie in es.createentitylist('hostage_entity'):
                es.setindexprop(hostie, 'CBaseEntity.m_CollisionGroup', wanb_collision)

def player_spawn(player):
    if wanb_enable == 1:
        uid = player['userid']
        es.setplayerprop(uid, 'CBaseEntity.m_CollisionGroup', wanb_collision)