# -*- coding: UTF-8 -*-
import es, playerlib, random, weaponlib, gamethread
from math import sqrt

#config
water_effect = 1 # 1 = on; 2 = off ; effet d'éclaboussure lorsque l'on touche l'ennemi
q3_hit_sound = 1 # bruit quake lorsque l'on touche l'ennemi
fast_move = 1 # poids des armes ignoré : vitesse de déplacement plus rapide et constante quelque soit l'arme
jump_on_fire = 1 # provoque un saut lorsque l'on tire à terre
jump_power = 650 # puissance de projection
delay_between_jump = 0.3 # délai minimum entre chaque projection
friendly_fire = 1 # mettre à 1 ou 0 pour activer/desactiver le friendly fire. (laisser la variable serveur mp_friendlyfire à 1)
air_precision = 1 # mettre à 1 pour que le joueur garde sa precision lorsqu'il est en l'air

# Information du script.
info = es.AddonInfo()
info.name = "FreeZe"
info.version = "1.1"
info.author = "Sulff"
info.basename = "Freezemod"
es.ServerVar('FreeZe', info.version, 'Sulff').makepublic()
#

cut_count = {}
cuts_to_unfreeze = 15 # nombre de coups de cut necessaire pour defreeze le joueur
gunlist = ('weapon_glock', 'weapon_usp', 'weapon_p228', 'weapon_deagle', 'weapon_fiveseven', 'weapon_elite')
forbid_weapon = ('hegrenade', 'smokegrenade', 'flashbang', 'knife')
delay_bump = {}

def load():
        es.doblock('corelib/noisy_on')
        
def unload():
        es.doblock('corelib/noisy_off')

def player_jump(ev):
        if air_precision:
                es.setplayerprop(ev['userid'], 'CBasePlayer.m_fFlags', 1)

def es_map_start(ev):
        es.stringtable('downloadables', 'sound/freezemod/sound_glass_1.mp3')
        es.stringtable('downloadables', 'sound/freezemod/sound_glass_echo2.mp3')
        es.stringtable('downloadables', 'sound/freezemod/hit_q3.wav')

        
        es.server.queuecmd("mp_friendlyfire 1") # FF on requis pour permettre le defreeze (detection des coups de cut par player_hurt())

def player_activate(ev):
        userid = ev['userid']
        cut_count[userid] = 0
        delay_bump[userid] = False

def player_death(ev):
        check_team()

def player_disconnect(ev):
        check_team()

def player_spawn(ev):
        userid = ev['userid']
        myPlayer = playerlib.getPlayer(userid)
        myPlayer.set('health', 612)
        # on met la sante a 612 pour que ça affiche 100 et que le joueur ne meure pas arrive a 0
        # on enlève l'influence du poids des armes sur la vitesse du joueur
        if fast_move:
                es.server.queuecmd("es_setplayerprop %s CBaseEntity.movetype 1"%userid)
        # on remet les caractéristiques normales aux joueurs
        current_player = playerlib.getPlayer(userid)
        current_player.freeze = 0
        es.server.queuecmd("es_fire %s !self color \"255 255 255\""%userid)
        es.server.queuecmd("es_fire %s !self addoutput \"rendermode 1\""%userid)
        es.server.queuecmd("es_fire %s !self alpha 255"%userid)
        es.server.queuecmd("es_fire %s shadow* color \"0 0 0\""%userid)
        
        # on enleve les objectifs de bases
        for x in ('func_bomb_target Disable','func_hostage_rescue Disable','weapon_c4 Kill','hostage_entity Kill'):
                es.server.queuecmd('es_fire %s %s'%(userid, x))
                
def player_hurt(ev):
        userid = ev['userid']
        attacker = ev['attacker']
        userid_team = ev['es_userteam']
        myPlayer = playerlib.getPlayer(userid)
        if attacker:
                myAttacker = playerlib.getPlayer(attacker)
                attacker_team = ev['es_attackerteam']
        degats = int(ev['dmg_health'])
        # son a intense variable quand on touche un ennemi
        if q3_hit_sound:
                if userid_team != attacker_team:
                        if degats < 100:
                                lvl = float(degats)/100
                        else:
                                lvl = 1.0
                        es.playsound(attacker, "freezemod/hit_q3.wav", lvl)
                # event freeze
        if (int(attacker) == 0):
                myPlayer.health += degats
        if not friendly_fire: # si ff off on redonne les hp perdus
                if (attacker_team == userid_team):
                        myPlayer.health += degats

        if (myPlayer.health <= 512):

                if (myPlayer.freeze != 1):
                        myPlayer.health = 512
                        # on met a 512 pour que la sante ne s'affiche pas
                        myPlayer.freeze = 1
                        es.server.queuecmd("es_fire %s player_weaponstrip strip"%(userid))
                        handle = es.getplayerhandle(userid) # on prend l'index du joueur a comparer
                        for index in weaponlib.getIndexList('#all'): # boucle sur tout les index a comparer
                                if es.getindexprop(index, 'CBaseEntity.m_hOwnerEntity') == handle: # on compare l'index du propriétaire de l'arme à l'index du joueur touché
                                        es.server.queuecmd('es_xremove %s'%index) # si ce sont les même, on fait disparaitre l'arme
                                
                        es.server.queuecmd("es_fire %s !self color \"0 255 255\""%userid)
                        es.server.queuecmd("es_fire %s !self addoutput \"rendermode 1\""%userid)
                        es.server.queuecmd("es_fire %s !self alpha 225"%userid)
                        es.server.queuecmd("es_fire %s shadow* color \"0 0 255\""%userid)

                        if (attacker_team != userid_team):
                                es.server.queuecmd('score set %s %s'%(attacker, myAttacker.kills+1))
                        else:
                                es.server.queuecmd('score set %s %s'%(attacker, myAttacker.kills-1))

# on règle le compteur comme pour des vrais kills

                check_team()
                
        elif water_effect:
                es.fire("%s !self DispatchEffect WaterSurfaceExplosion"%userid)

# on bloque les hp une fois freezé
        if myPlayer.freeze == 1:
                myPlayer.health = 512

# event defreeze
        if (userid_team == attacker_team) and (myPlayer.freeze == 1):
                if ev['weapon'] == 'knife':
                        cut_count[userid] += 1
                        es.emitsound('player', attacker, "freezemod/sound_glass_1.mp3", 0.4, 0.3)
        if cut_count[userid] >= cuts_to_unfreeze:
                cut_count[userid] = 0

                myPlayer.health = 612

                es.server.queuecmd("es_fire %s !self color \"255 255 255\""%userid)
                es.server.queuecmd("es_fire %s !self alpha 255"%userid)
                rand = random.randint(0,5)
                es.server.queuecmd("es_give %s %s"%(userid, gunlist[rand])) # on donne une arme de poing au hasard lors du defreeze

                myPlayer.freeze = 0

def check_team():
        TerroList = playerlib.getPlayerList('#t, #alive')
        CtList = playerlib.getPlayerList('#ct, #alive')

        slay_team(TerroList)
        slay_team(CtList)

def slay_team(teamlist):
        found_unfreeze = True
        for player in teamlist:
                loop_player = playerlib.getPlayer(player)
                if loop_player.freeze == 0:
                        found_unfreeze = False
                        break

        if found_unfreeze:
                playerList = playerlib.getPlayerList('#all')
                for player in playerList:
                        es.playsound(player, 'freezemod/sound_glass_echo2.mp3', 1)
                for player in teamlist:
                        es.sexec(player, 'kill')
                        
def weapon_fire(ev):
        userid = ev['userid']
        myPlayer = playerlib.getPlayer(userid)
        
        if air_precision:
                es.setplayerprop(userid, 'CBasePlayer.m_fFlags', 1) # variable qui indique l'état au sol/en l'air du joueur et modifie la précision en conséquence
                
        if ev['weapon'] not in forbid_weapon:

                if (delay_bump[userid] == False) and (jump_on_fire == 1):
                        ViewAngle = round(es.getplayerprop(userid, 'CCSPlayer.m_angEyeAngles[' + str(0) + ']'))
                        ViewAngle2 = round(es.getplayerprop(userid, 'CCSPlayer.m_angEyeAngles[' + str(1) + ']'))

                        location_aim = ViewCoord(userid) # coordonnées du point visé
                        location_aim = location_aim.split(",")
                        x2, y2, z2 = location_aim
                        x2, y2, z2 = float(x2), float(y2), float(z2)
                        location_aim = x2, y2, z2

                        x, y, z = es.getplayerlocation(userid) # coordonnées du joueur
                        location_player = (float(x), float(y), float(z)+60) # on ajoute 60 à l'axe z pour avoir la position de l'arme
                        #(servira pour calculer le vecteur de propulsion)
                        location_player2 = (float(x), float(y), float(z)+30) # on prend aussi la position intermediaire entre les pieds et l'arme
                        # (servira pour calculer la variation de force basée sur la distance de maniere égale entre le tir au sol et sur le mur) 
                        dist = CalcDistance(location_aim, location_player) # vecteur utilisé pour la propulsion
                        dist_mid = CalcDistance(location_aim, location_player2) # vecteur utilisé pour la distance
                        if (dist_mid[0] < 110):

                                dist2 = dist[1]*-(1), dist[2]*-(1), dist[3]*-(1) # inversion du vecteur (pour repousser le joueur par rapport au point visé)

                                dist2_norma = dist2[0]/dist[0], dist2[1]/dist[0], dist2[2]/dist[0] # normalisation du vecteur

                                if dist_mid[0]:
                                        coef_power = 1 - round((dist_mid[0]/300), 2)
                                else:
                                        coef_power = 1

                                        
                                power = []
                                power = [(dist2_norma[x] * (coef_power*jump_power)) for x in range(0,3)]  # application de la puissance voulue
                                
                                es.setplayerprop(userid, 'CBasePlayer.localdata.m_vecBaseVelocity', "%s,%s,%s"%(power[0], power[1], power[2]))

                                delay_bump[userid] = True
                                gamethread.delayed(delay_between_jump, reset_delay, userid)

        # on force le drop de l'arme si un joueur tire alors qu'il est freeze
        myPlayer = playerlib.getPlayer(userid)
        if myPlayer.freeze:
                es.sexec(userid, 'drop')
                
def reset_delay(userid):
        delay_bump[userid] = False

def ViewCoord(userid): # méthode pour avoir la location de l'endroit visé sans bug
        es.server.cmd('es_xprop_dynamic_create %s props_c17/tv_monitor01_screen.mdl' % userid)
        lastgive = es.ServerVar('eventscripts_lastgive')
        location = es.getindexprop(lastgive, 'CBaseEntity.m_vecOrigin')
        es.server.queuecmd('es_xremove ' + lastgive)
        return location

def CalcDistance(location_end, location_start): # on calcule la distance (en game units) entre les 2 points

        X = location_end[0] - location_start[0]
        Y = location_end[1] - location_start[1]
        Z = location_end[2] - location_start[2]

        distance = X**2 + Y**2 + Z**2
        distance = (sqrt(distance), X, Y, Z)

        return distance
