# -*- coding:Utf-8 -*-

# ==================================================
#  >> IMPORTATIONS                                 #
# ==================================================


import es
import langlib

import os
import re
import shelve
import datetime

import psyco
psyco.full()


# ==================================================
#  >> INFORMATIONS                                 #
# ==================================================


temp = {
   'name'       : 'Show-Damage',
   'version'    : '2.5',
   'date'       : '2010-04-16',
   'author'     : 'L\'In20Cible',
   'description': 'Annonce les dommages causés directement au milieu de son écran.',
   'url'        : 'http://addons.eventscripts.com/addons/view/showdamage',
   'basename'   : 'showdamage'
   }
   
informations = es.AddonInfo()
for information in temp:
   informations[information] = temp[information]
   
es.ServerVar('sd_version', (informations['version'] + ' by ' + informations['author'])).makepublic()


# ==================================================
#  >> INITIALISATION                               #
# ==================================================


def load():
   Initialization()
   es.addons.registerSayFilter(SayFilterCallBack)
   
   
def Initialization():
   global admins, players, options, weapons, settings, translations
   
   players = dict()
   
   options = {
      'enable'        : ('1', 'Active/Désactive le Show-Damage.'),
      'admins'        : ('0', 'Active/désactive la restriction du Show-Damage aux joueurs qui ne sont pas administrateur.'),
      'status'        : ('1', 'Définit le statut par défaut du Show-Damage pour les nouveaux joueurs.'),
      'weapon'        : ('0', 'Active/désactive la prise en compte des armes.'),
      'advert'        : ('1', 'Active/désactive l\'annonce au début de chaque round.'),
      'saycmd'        : ('!ShowDamage', 'Définit la commande t\'chat qui permet d\'activer/désactiver le Show-Damage'),
      'saycmd_display': ('1', 'Active/désactive l\'affichage de la commande dans la boite de clavardage.')
      }
   for option in options:
      options[option] = es.ServerVar(('sd_' + option), options[option][0], options[option][1])
   filepath = GetConfigurationFilePath('configuration.cfg')
   if os.path.isfile(filepath):
      es.mexec(filepath.replace(str(es.ServerVar('eventscripts_gamedir')).replace(os.sep, '/'), '..'))
      
   settings = shelve.open(GetConfigurationFilePath('settings.db'), 'c', None, True)
   
   translations = TranslationsAreMissingCallBack
   filepath = GetConfigurationFilePath('translations.ini')
   if os.path.isfile(filepath):
      try:
         translations = langlib.Strings(filepath)
      except:
         pass
   admins = GetConfigurationFileCleaned(GetConfigurationFilePath('admins.txt'))
   weapons = GetConfigurationFileCleaned(GetConfigurationFilePath('weapons.txt'))
   
   
def unload():
   settings.close()
   es.addons.unregisterSayFilter(SayFilterCallBack)
   
   
# ==================================================
#  >> UTILITAIRES                                  #
# ==================================================


def GetConfigurationFilePath(filename):
   return os.path.join(es.getAddonPath(informations.basename), 'configuration', filename).replace(os.sep, '/')
   
   
def GetConfigurationFileCleaned(filepath):
   returnvalue = list()
   if not os.path.isfile(filepath):
      return returnvalue
   regex = re.compile('')
   for fileline in open(filepath):
      fileline = regex.sub('', fileline).strip()
      if not fileline:
         continue
      returnvalue.append(fileline)
   return returnvalue
   
   
def GetPlayerSteamID(userid):
   userid = int(userid)
   if not es.exists('userid', userid):
      return
   usersteamid = es.getplayersteamid(userid)
   if int(es.ServerVar('sv_lan')) or (usersteamid == 'STEAM_ID_LAN'):
      usersteamid = es.createplayerlist(userid)[userid]['address'].split(':')[0]
   return usersteamid
   
   
def GetPlayerLanguage(userid):
   return langlib.getLangAbbreviation(es.getclientvar(userid, 'cl_language'))
   
   
def TellPlayerString(userid, string):
   es.tell(userid, '#multi', ('#green[Show-Damage] #default' + string))
   
   
def ShowPlayerDamage(userid, damages):
   userid = int(userid)
   if not es.exists('userid', userid) or es.isbot(userid):
      return
   damages = int(damages)
   if userid not in players:
      players[userid] = damages
   else:
      players[userid] = (players[userid] + damages)
   usersteamid = GetPlayerSteamID(userid)
   if ((int(options['admins']) and usersteamid in admins) or not int(options['admins'])) and (((usersteamid not in settings) and int(options['status'])) or ((usersteamid in settings) and settings[usersteamid]['status'])):
      es.centertell(userid, ('-' + str(damages) + 'HP'))
      
      
def ShowPlayerTotalDamage(userid):
   userid = int(userid)
   usersteamid = GetPlayerSteamID(userid)
   if ((usersteamid not in settings) and not int(options['status'])) or ((usersteamid in settings) and not settings[usersteamid]['status']) or (int(options['admins']) and usersteamid not in admins):
      return
   if (userid in players) and (players[userid] <> 0):
      tokens = {
         'damages': str(players[userid])
         }
      TellPlayerString(userid, translations('showdamage', tokens, GetPlayerLanguage(userid)))
   else:
      TellPlayerString(userid, translations('nodamage', dict(), GetPlayerLanguage(userid)))
      
      
# ==================================================
#  >> FONCTIONS D'APPEL                            #
# ==================================================


def TranslationsAreMissingCallBack(string, tokens, language):
   return 'Sorry, unable to read the #lightgreentranslations.ini #defaultfile.'
   
   
def SayFilterCallBack(userid, string, teamonly):
   if not int(options['enable']) or (string.lower().strip('"') != str(options['saycmd']).lower()) or (int(options['admins']) and GetPlayerSteamID(userid) not in admins):
      return userid, string, teamonly
   usersteamid = GetPlayerSteamID(userid)
   if usersteamid not in settings:
      settings[usersteamid] = {
         'status'  : True,
         'datetime': datetime.date.today()
         }
   if settings[usersteamid]['status']:
      settings[usersteamid]['status'] = False
   else:
      settings[usersteamid]['status'] = True
   TellPlayerString(userid, translations(('enable' if settings[usersteamid]['status'] else 'disable'), dict(), GetPlayerLanguage(userid)))
   if not int(options['saycmd_display']):
      userid = 0
   return userid, string, teamonly
   
   
# ==================================================
#  >> ÉVÉNEMENTS                                   #
# ==================================================


def es_map_start(event_var):
   Initialization()
   if not len(settings):
      return
   for playersteamid in settings:
      if not (datetime.date.today() - settings[playersteamid]['datetime']).days >= 7:
         continue
      del settings[playersteamid]
      
      
def round_freeze_end(event_var):
   if not int(options['enable']) or not int(options['advert']):
      return
   for playerid in es.getUseridList():
      if es.isbot(playerid) or (int(options['admins']) and GetPlayerSteamID(playerid) not in admins):
         continue
      tokens = {
         'saycmd' : str(options['saycmd']).lower()
         }
      TellPlayerString(playerid, translations('advert', tokens, GetPlayerLanguage(playerid)))
      
      
def round_end(event_var):
   if not int(options['enable']):
      return
   for playerid in es.getUseridList():
      if es.isbot(playerid) or es.getplayerprop(playerid, 'CBasePlayer.pl.deadflag'):
         continue
      ShowPlayerTotalDamage(playerid)
   for playerid in players:
      if not players[playerid] <> 0:
         continue
      players[playerid] = 0
      
      
def player_spawn(event_var):
   userid = int(event_var['userid'])
   if userid in players:
      players[userid] = 0
   usersteamid = GetPlayerSteamID(event_var['userid'])
   if usersteamid not in settings:
      return
   settings[usersteamid]['datetime'] = datetime.date.today()
   
   
def player_death(event_var):
   userid = int(event_var['userid'])
   if not int(options['enable']) or es.isbot(userid):
      return
   ShowPlayerTotalDamage(userid)
   
   
def player_hurt(event_var):
   if not int(options['enable']) or (int(options['weapon']) and (event_var['weapon'] not in weapons)):
      return
   ShowPlayerDamage(event_var['attacker'], event_var['dmg_health'])
      
def player_falldamage(event_var):
   ShowPlayerDamage(event_var['userid'], event_var['damage'].split('.')[0])